let vhcle_url="/vehicles/listings";
let book_url="/trips/booked";
let reservation_url="/reservation/";
let earnings_url="/earnings";
let turo_url="turo.com";
var current_url=document.location.href;
let last_record_entry;
const base = current_url.split("/").slice(0, 5).join("/");
function createInstructionPopup() {
    // Create overlay background
    const overlay = document.createElement('div');
    overlay.style.position = 'fixed';
    overlay.style.top = '0';
    overlay.style.left = '0';
    overlay.style.width = '100%';
    overlay.style.height = '100%';
    overlay.style.backgroundColor = 'rgba(0, 0, 0, 0.5)';
    overlay.style.display = 'flex';
    overlay.style.justifyContent = 'center';
    overlay.style.alignItems = 'center';
    overlay.style.zIndex = '10000';
    overlay.style.fontFamily = 'Arial, sans-serif';

    // Create popup container
    const popup = document.createElement('div');
    popup.style.backgroundColor = 'white';
    popup.style.padding = '25px';
    popup.style.borderRadius = '12px';
    popup.style.boxShadow = '0 10px 30px rgba(0, 0, 0, 0.3)';
    popup.style.maxWidth = '350px';
    popup.style.width = '90%';
    popup.style.textAlign = 'center';
    popup.style.position = 'relative';

    // Create title
    const title = document.createElement('h3');
    title.textContent = 'Action Required';
    title.style.margin = '0 0 15px 0';
    title.style.color = '#333';
    title.style.fontSize = '18px';
    title.style.fontWeight = 'bold';

    // Create message
    const message = document.createElement('p');
    message.textContent = 'Please navigate to the Transaction History page first, then click the Sync Data button to import your earnings data.';
    message.style.margin = '0 0 20px 0';
    message.style.color = '#666';
    message.style.fontSize = '14px';
    message.style.lineHeight = '1.5';

    // Create close button
    const closeButton = document.createElement('button');
    closeButton.textContent = 'Got it!';
    closeButton.style.backgroundColor = '#4f46e5';
    closeButton.style.color = 'white';
    closeButton.style.border = 'none';
    closeButton.style.padding = '10px 20px';
    closeButton.style.borderRadius = '6px';
    closeButton.style.fontSize = '14px';
    closeButton.style.fontWeight = '600';
    closeButton.style.cursor = 'pointer';
    closeButton.style.transition = 'background-color 0.2s';

    // Hover effect for close button
    closeButton.addEventListener('mouseenter', () => {
        closeButton.style.backgroundColor = '#4338ca';
    });
    closeButton.addEventListener('mouseleave', () => {
        closeButton.style.backgroundColor = '#4f46e5';
    });

    // Close popup when button is clicked
    closeButton.addEventListener('click', () => {
        document.body.removeChild(overlay);
    });

    // Close popup when clicking outside
    overlay.addEventListener('click', (e) => {
        if (e.target === overlay) {
            document.body.removeChild(overlay);
        }
    });

    // Close popup with Escape key
    const handleEscape = (e) => {
        if (e.key === 'Escape') {
            document.body.removeChild(overlay);
            document.removeEventListener('keydown', handleEscape);
        }
    };
    document.addEventListener('keydown', handleEscape);

    // Assemble popup
    popup.appendChild(title);
    popup.appendChild(message);
    popup.appendChild(closeButton);
    overlay.appendChild(popup);
    document.body.appendChild(overlay);

    // Focus the close button for accessibility
    closeButton.focus();
}
chrome.runtime.onMessage.addListener(async(message, sender, sendResponse) => {
    console.log("message recieved"+message);
    if (message.action === "start_process") {
        
        console.log("Received request for prcoess");
        last_record_entry=message.last_record_entry;
        sendResponse({msg:true});

        if(!document.querySelector("h1")?.textContent?.includes("Transaction history")){
          console.log("it is not history page.")
createInstructionPopup();
          return;
        }
        // Grab required data from the page
        sessionStorage.strtprcess="true";
        // fetchandUpdateEarnings();
        myScrapper()
        // start_process();
        // Send data to background for storage
        // chrome.runtime.sendMessage({ action: "loaddata", tabId: sender.tab.id, data: all_data });
    }
    if (message.action === "data_sent") {
        alert(message.result);
    }
});

// window.addEventListener("message", function (event) {
//     if (event.source !== window) return; // Only accept messages from same window
  
//     if (event.data.type === "TROHOST_LGIN") {
//         console.log("userId:", event.data.userId);
//         console.log("userName:", event.data.userName);
//       let result=  {
//             userId: event.data.userId,
//             userName: event.data.userName
//           };
//       chrome.storage.local.set({ "turo_hst_user": result }, () => {
//         console.log("User saved in chrome.storage");
//       });
      
//     }
//   });

window.onload = () => {
  
    console.log("true");
    // sessionStorage.strtprcess="true";
    console.log("process");
    if (sessionStorage.getItem("strtprcess") === "true") {

        console.log("process started");

       
// if(current_url.match(vhcle_url))
// {
//   setTimeout(() => {
//     scrap_all_vehicles();
//   }, 5000);  
// }

// if(current_url.match(book_url))
//     {
        
//         setTimeout(() => {
//             scrap_all_bookings();
//           }, 5000);  
//     }
//     if(current_url.match(reservation_url))
//         {
            
//             setTimeout(() => {
//                 fetchTripEarnings();
//               }, 5000);  
//         }


const url = new URL(currentUrl);

const domain = url.hostname;
const pathParts = url.pathname.split('/').filter(Boolean);
const lastSlug = pathParts[pathParts.length - 1];

console.log("Domain:", domain);
console.log("Last Slug:", lastSlug);
     if(domain.match(turo_url) && lastSlug.match(earnings_url))
            {
                
                setTimeout(() => {
                    fetchandUpdateEarnings();
                  }, 5000);  
            }
}
};
function start_process(){
    go_to_page(vhcle_url);
}
function go_to_page(url_)
{
    window.location.href=base+url_;
}

function scrap_all_vehicles()
{
    let all_vehicles=[];
    let d_all_vehicles=document.querySelectorAll("a[data-testid='vehicle-listing-details-card']");
    d_all_vehicles.forEach(d_vehicle => {
        let vehicle={};
        let p_s=d_vehicle.querySelectorAll("div.css-1wd514c-VehicleDetailsCard p");
        vehicle.name=p_s[0].innerText;
        vehicle.model=p_s[1].innerText;
        vehicle.n_plate=p_s[2].getAttribute('title');
        console.log(vehicle);
        all_vehicles.push(vehicle);
    });
    console.log(all_vehicles);
   setTimeout(() => {
    go_to_page(book_url);
   }, 5000); 
    
   return all_vehicles;
}

function scrap_all_bookings()
{
    let all_bkgs=[];
    let d_all_bkgs=document.querySelectorAll("div[data-testid='trips-upcoming-trips-list'] a[data-testid='baseTripCard']");
    d_all_bkgs.forEach(d_bkg => {
        console.log(d_bkg);
        let bkg={};
        let p_s=d_bkg.querySelectorAll("div.css-m4iqw2-BaseTripCard p");
        let href = d_bkg.getAttribute('href');  // Get the href attribute
let urlParts = href.split('/');  // Split by '/'
urlParts.splice(0, 3);  // Remove the first three parts: us, en, and the initial empty string
let modifiedHref = '/' + urlParts.join('/'); 

        bkg.link=modifiedHref;
        bkg.name=p_s[0].innerText;
        bkg.addres=p_s[1].innerText;
        bkg.person= d_bkg.querySelectorAll("div.css-m4iqw2-BaseTripCard div.css-1b8mqrq-BaseTripCard p")[0].innerText;
        bkg.n_plate=d_bkg.querySelectorAll("div.css-2m9xmi-BaseTripCard p")[0].innerText;
        console.log(bkg);
        all_bkgs.push(bkg);
       
    });
    console.log(all_bkgs);
    setTimeout(() => {
        go_to_page(all_bkgs[0].link);
       }, 5000); 
    return all_bkgs;
}

function fetchTripEarnings()
{
    let d_all_bkgs=document.querySelector(".reservationDetails-totalEarnings div.detailsSection-description p").innerText;
    console.log("earnings from trip");
    console.log(d_all_bkgs);

}

function fetchandUpdateEarnings()
{
console.log(last_record_entry);

    const rows = Array.from(document.querySelectorAll("table tr"));
    
    const matchingRows = rows.filter(tr => {
      const a = tr.querySelectorAll("td")[0]?.querySelector("a");
      return a && a.textContent.toLowerCase().includes("trip");
    });
    
    const targetIndex = matchingRows.findIndex(tr => {
        const td = tr.querySelectorAll("td")[1];
        const p = td?.querySelector("p");
        return p && p.textContent.trim() === last_record_entry;
      });
      
      // Get all rows **before** the matched row
      const rowsAbove = targetIndex !== -1 ? matchingRows.slice(0, targetIndex) : [];
      
      let rows_to_fetch= last_record_entry!==null ? rowsAbove : matchingRows;
      rows_to_fetch.forEach(singlerow => {
        let vehicle_name=singlerow.querySelectorAll("td")[0].querySelectorAll("p")[0].textContent.replace(" With ","");
        let vehicle_user=singlerow.querySelectorAll("td")[0].querySelectorAll("a")[0].textContent.replace(/(’|')s trip/i, "").trim();
        let id_of_earning=singlerow.querySelectorAll("td")[1].querySelector("p").textContent;
        let date_of_earning=singlerow.querySelectorAll("td")[2].querySelector("p").textContent;
        let vehicle_earning=singlerow.querySelectorAll("td")[3].querySelector("p").textContent;
        addEarning(vehicle_name, date_of_earning, vehicle_earning, vehicle_user,id_of_earning) 
        
    });
console.log(earningsData);
sessionStorage.strtprcess="false";
console.log("earningsData: " , earningsData);
if (!earningsData || Object.keys(earningsData).length === 0) {
    alert("No Data Available to Send, it's Already Synced");
  } else {
    // chrome.runtime.sendMessage({ action: "send_data", data: earningsData });
    console.log({ action: "send_data", data: earningsData });
  }

}
console.log("ridesheets injected")
let earningsData = {};
function addEarning(vehicleName, dateOfEarning, amount, user,id_of_earning) {
    if (!earningsData[vehicleName]) {
      earningsData[vehicleName] = {};
    }
  
    if (!earningsData[vehicleName][dateOfEarning]) {
      earningsData[vehicleName][dateOfEarning] = [];
    }
  
    earningsData[vehicleName][dateOfEarning].push({ amount, user,id_of_earning });
  }
  

function myScrapper(){
    async function scrapeVirtualTable() {
  // Find scroll container
  let scrollContainer = document.querySelector('tbody')?.parentElement;
  while (scrollContainer && scrollContainer.scrollHeight <= scrollContainer.clientHeight) {
    scrollContainer = scrollContainer.parentElement;
  }
  if (!scrollContainer) scrollContainer = window;

  const scrapedData = new Map(); // key = unique ID, value = row data
  const delay = ms => new Promise(res => setTimeout(res, ms));

  function getVisibleRows() {
    const rows = Array.from(document.querySelectorAll('tr[data-testid="earningsTableDesktop-row"]'));
    return rows.map(row => {
      const description = row.querySelector('.e1p6hp1s0')?.innerText || '';
      const subText = row.querySelector('.css-1bhh7id-StyledText-TrimText')?.innerText || '';
      const reservation = row.querySelector('.css-vxxe06-TD-ReservationCell p')?.innerText || '';
      const date = row.querySelector('.css-hs1krk-TD-DateCell p')?.innerText || '';
      const earnings = row.querySelector('[data-testid="earningsTableDesktop-earningsCell"] span')?.innerText || '';
      const payment = row.querySelector('[data-testid="earningsTableDesktop-paymentCell"] span')?.innerText || '';
      const key = reservation || description + date; // unique key
      return { key, data: { description, subText, reservation, date, earnings, payment } };
    });
  }

  let newRowsFound = true;
  while (newRowsFound) {
    newRowsFound = false;

    const visibleRows = getVisibleRows();
    for (const row of visibleRows) {
      if (!scrapedData.has(row.key)) {
        scrapedData.set(row.key, row.data);
        newRowsFound = true;
      }
    }

    // Scroll
    if (scrollContainer === window) {
      window.scrollBy(0, 500);
    } else {
      scrollContainer.scrollTop += 500;
    }

    await delay(300);
  }

  return Array.from(scrapedData.values());
}


scrapeVirtualTable().then(data => {
  // Filter rows that contain "trip" in the description
  const tripRows = data.filter(row => row.description.toLowerCase().includes("trip"));
  console.log('Total trip rows:', tripRows.length);

  tripRows.forEach(row => {
    // Trim and clean the vehicle name (remove " With " if present)
    let vehicle_name = row.subText.replace(/^With\s+/i, "").trim();

    // Trim and clean the user name (remove "'s trip" or "’s trip")
    let vehicle_user = row.description.replace(/(’|')s trip/i, "").trim();

    // Get ID and earnings directly
    let id_of_earning = row.reservation;
    let date_of_earning = row.date;
    let vehicle_earning = row.earnings;

    // Add to earningsData using the same function
    addEarning(vehicle_name, date_of_earning, vehicle_earning, vehicle_user, id_of_earning);
  });
  if(earningsData && Object.keys(earningsData).length > 0){
    chrome.runtime.sendMessage({ action: "send_data", data: earningsData });
    let scrollContainer = document.querySelector('tbody')?.parentElement;
     scrollContainer.scrollTop = 0;

  }
  console.log(earningsData); // Check the structured data
});


}