function myFunction() {
  
}
function doPost(e) {
  try {
    // Parse the JSON payload
    var data = JSON.parse(e.postData.contents);
    
    // Extract email details from the payload
    var recipient = data.recipient;
    var subject = data.subject;
    var body = data.body;
    var attachmentIds = data.attachmentIds || []; // Expecting an array of file IDs
    var from = data.from;
    // Initialize arrays to store attachments and inline images
    var attachments = [];
    var inlineImages = {};

    // Process each file ID and fetch the file
    attachmentIds.forEach(function(fileId, index) {
      try {
        var file = DriveApp.getFileById(fileId);
        var blob = file.getBlob();
        var mimeType = file.getMimeType();
        var fileName = file.getName();
        attachments.push(file.getAs(mimeType));
        
      } catch (error) {
        Logger.log('Error fetching file from Drive: ' + fileId + ' - ' + error);
      }
    });

  var attachmentsData = data.attachments || [];
    
    // Decode the attachments
   var attachments_inline = {};
attachmentsData.forEach(function(file) {
  try {
    var blob = Utilities.newBlob(Utilities.base64Decode(file.content), file.type, file.name);
    // Use the file name as the CID (you can customize this)
    var cid = file.name.split('.')[0]; // e.g., "image1" for "image1.png"
    attachments_inline[cid] = blob;
  } catch (error) {
    Logger.log('Error processing inline image: ' + error);
  }
});
var aliases = GmailApp.getAliases();
Logger.log(aliases);
    // Send the email with attachments and inline images
    GmailApp.sendEmail(
     recipient,
      subject,
      body,{
      attachments: attachments,
      inlineImages:attachments_inline,
     from:from
    });

    // Return a success response
    return ContentService.createTextOutput("Email sent successfully");
    
  } catch (error) {
    Logger.log('Error in doPost: ' + error.message);
    return ContentService.createTextOutput("Error sending email: " + error.message);
  }
}
