// Show spinner immediately when popup opens
document.getElementById("spinner").classList.remove("hidden");
document.getElementById("signuploginscreen").classList.add("hidden");
document.getElementById("loggedinscreen").classList.add("hidden");

// Function to hide spinner and show appropriate screen
function hideSpinnerAndShowUI() {
    console.log()
    document.getElementById("spinner").classList.add("hidden");
}

// Function to check login status
function checkLoginStatus() {
    chrome.storage.local.get("turo_hst_user", (storageResponse) => {
        const userData = storageResponse.turo_hst_user;
        
        if (userData && userData.loggedIn && false) {
            // User is logged in (from local storage)
            console.log("User logged in from local storage", userData);
            document.getElementById("user_name").innerText = userData.user;
            document.getElementById("signuploginscreen").classList.add("hidden");

      document.getElementById("loggedinscreen").classList.remove("hidden");
      hideSpinnerAndShowUI();
    } else {
      // Not logged in locally, check with backend immediately
      chrome.runtime.sendMessage(
        {
          action: "getloginStatus",
        },
        (backendResponse) => {
          if (backendResponse && backendResponse.status === 'Successfull' && backendResponse.data.loggedIn) {
            // Backend confirms user is logged in
            console.log("the dashboard")
            console.log("User logged in from backend", backendResponse.data);
            document.getElementById("user_name").innerText = backendResponse.data.user;
            document.getElementById("signuploginscreen").classList.add("hidden");
            document.getElementById("loggedinscreen").classList.remove("hidden");
          } else {
            // User is not logged in
            document.getElementById("signuploginscreen").classList.remove("hidden");
            document.getElementById("loggedinscreen").classList.add("hidden");
          }
          hideSpinnerAndShowUI();
        }
      );
    }
  });
}

// Event listeners
document.getElementById("logginBtn").addEventListener("click", () => {
  chrome.runtime.sendMessage({ action: "gotologinpage" });
  // Show spinner again after clicking login
  document.getElementById("spinner").classList.remove("hidden");
  document.getElementById("signuploginscreen").classList.add("hidden");
  
  // Check login status after 3 seconds
  setTimeout(() => {
    checkLoginStatus();
  }, 3000);
});

document.getElementById("sync_data_Btn").addEventListener("click", () => {
  chrome.runtime.sendMessage({
    action: "checkMasterSync",
  });
});

document.getElementById("go_to").addEventListener("click", () => {
  chrome.runtime.sendMessage({
    action: "gotoapppage",
  });
});

// Check if we're on turo.com
chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
  const url = tabs[0].url;
  if (!url.includes("turo.com")) {
    document.body.innerHTML = "<p style='color:white;'>This extension only works on turo.com</p>";
  } else {
    // Start checking login status immediately
    checkLoginStatus();
  }
});